<?php

namespace App\Filament\Resources\ProjectCharterResource\Pages;

use App\Filament\Resources\ProjectCharterResource;
use App\Models\ProjectCharter;
use Archilex\AdvancedTables\AdvancedTables;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListProjectCharters extends ListRecords
{
    use AdvancedTables;

    protected static string $resource = ProjectCharterResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        $statuses = ProjectCharter::getStatuses();
        $tabs = [];

        foreach ($statuses as $status => $trnslatedStatus) {
            $tabs[$status] = Tab::make(__($trnslatedStatus))
                ->modifyQueryUsing(fn (Builder $query) => $query->where('status', $status))
                ->badge(ProjectCharter::where('status', $status)->ownScope()->count());
        }

        return $tabs;
    }
}
