<?php

namespace App\Filament\Resources\ProjectCharterResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectCharterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'description' => 'required|string',
            'start_date' => 'required|date',
            'expected_end_date' => 'required|date',
            'estimated_cost' => 'required',
            'total_cost' => 'required',
            'status' => 'required',
            'initiative_project_id' => 'required',
            'order_id' => 'required',
            'created_by' => 'required',
            'service_provider_id' => 'required',
        ];
    }
}
