<?php

namespace App\Filament\Resources\ProjectCharterResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterResource;
use App\Filament\Resources\ProjectCharterResource\Api\Requests\UpdateProjectCharterRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ProjectCharter
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateProjectCharterRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
