<?php

namespace App\Filament\Resources\ProjectCharterResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterResource;
use App\Filament\Resources\ProjectCharterResource\Api\Transformers\ProjectCharterTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterResource::class;

    /**
     * Show ProjectCharter
     *
     * @return ProjectCharterTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new ProjectCharterTransformer($query);
    }
}
