<?php

namespace App\Filament\Resources\ProjectCharterResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterResource;
use App\Filament\Resources\ProjectCharterResource\Api\Requests\CreateProjectCharterRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ProjectCharter
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateProjectCharterRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
