<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Pages;

use App\Filament\Resources\ProjectCharterEscalationRequestResource;
use App\Models\ProjectCharterEscalationRequest;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\ViewRecord;
use Illuminate\Support\Facades\Auth;

class ViewProjectCharterEscalationRequest extends ViewRecord
{
    protected static string $resource = ProjectCharterEscalationRequestResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('resolve_level_1')
                ->label(__('project_charter_escalation_request.resolve_level_1'))
                ->icon('heroicon-o-check-circle')
                ->color('success')
                ->visible(fn (ProjectCharterEscalationRequest $record): bool => $record->canResolveLevel1())
                ->form([
                    \Filament\Forms\Components\Textarea::make('resolution_notes')
                        ->label(__('project_charter_escalation_request.resolution_notes'))
                        ->placeholder(__('project_charter_escalation_request.resolution_notes_placeholder'))
                        ->required()
                        ->maxLength(65535)
                        ->rows(3),
                ])
                ->action(function (ProjectCharterEscalationRequest $record, array $data): void {
                    $result = $record->resolveLevel1($data['resolution_notes']);

                    if ($result) {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.escalation_resolved_level_1'))
                            ->success()
                            ->send();

                        // Redirect to the updated record
                        $this->redirect($this->getResource()::getUrl('view', ['record' => $record]));
                    } else {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.cannot_resolve'))
                            ->danger()
                            ->send();
                    }
                }),

            Actions\Action::make('escalate_to_level_2')
                ->label(__('project_charter_escalation_request.escalate_to_level_2'))
                ->icon('heroicon-o-arrow-up')
                ->color('warning')
                ->visible(fn (ProjectCharterEscalationRequest $record): bool => $record->canEscalateToLevel2())
                ->form([
                    \Filament\Forms\Components\Textarea::make('escalation_notes')
                        ->label(__('project_charter_escalation_request.escalation_notes'))
                        ->placeholder(__('project_charter_escalation_request.escalation_notes_placeholder'))
                        ->maxLength(65535)
                        ->rows(3),
                ])
                ->action(function (ProjectCharterEscalationRequest $record, array $data): void {
                    $result = $record->escalateToLevel2($data['escalation_notes'] ?? '');

                    if ($result) {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.escalation_escalated_to_level_2'))
                            ->success()
                            ->send();

                        // Redirect to the updated record
                        $this->redirect($this->getResource()::getUrl('view', ['record' => $record]));
                    } else {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.cannot_escalate'))
                            ->danger()
                            ->send();
                    }
                }),

            Actions\Action::make('resolve_level_2')
                ->label(__('project_charter_escalation_request.resolve_level_2'))
                ->icon('heroicon-o-check-circle')
                ->color('success')
                ->visible(fn (ProjectCharterEscalationRequest $record): bool => $record->canResolveLevel2())
                ->form([
                    \Filament\Forms\Components\Textarea::make('resolution_notes')
                        ->label(__('project_charter_escalation_request.resolution_notes'))
                        ->placeholder(__('project_charter_escalation_request.resolution_notes_placeholder'))
                        ->required()
                        ->maxLength(65535)
                        ->rows(3),
                ])
                ->action(function (ProjectCharterEscalationRequest $record, array $data): void {
                    $result = $record->resolveLevel2($data['resolution_notes']);

                    if ($result) {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.escalation_resolved_level_2'))
                            ->success()
                            ->send();

                        // Redirect to the updated record
                        $this->redirect($this->getResource()::getUrl('view', ['record' => $record]));
                    } else {
                        Notification::make()
                            ->title(__('project_charter_escalation_request.cannot_resolve'))
                            ->danger()
                            ->send();
                    }
                }),

            Actions\EditAction::make()
                ->visible(
                    fn (ProjectCharterEscalationRequest $record): bool => Auth::user()->can('update', $record) && ! $record->isResolved()
                ),
        ];
    }
}
