<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateProjectCharterEscalationRequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'project_charter_id' => 'required',
            'risk_register_id' => 'required',
            'problem' => 'required|string',
            'details' => 'required|string',
            'status' => 'required',
            'requested_by' => 'required',
            'level_1_reviewed_by' => 'required',
            'level_1_resolution_notes' => 'required|string',
            'level_1_resolved_at' => 'required',
            'level_2_reviewed_by' => 'required',
            'level_2_resolution_notes' => 'required|string',
            'level_2_resolved_at' => 'required',
        ];
    }
}
