<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterEscalationRequestResource;
use App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Requests\UpdateProjectCharterEscalationRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterEscalationRequestResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ProjectCharterEscalationRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateProjectCharterEscalationRequestRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
