<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterEscalationRequestResource;
use App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Transformers\ProjectCharterEscalationRequestTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class PaginationHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterEscalationRequestResource::class;

    /**
     * List of ProjectCharterEscalationRequest
     *
     * @param  Request  $request
     * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
     */
    public function handler()
    {
        $query = static::getEloquentQuery();

        $query = QueryBuilder::for($query)
            ->allowedFields($this->getAllowedFields() ?? [])
            ->allowedSorts($this->getAllowedSorts() ?? [])
            ->allowedFilters($this->getAllowedFilters() ?? [])
            ->allowedIncludes($this->getAllowedIncludes() ?? [])
            ->paginate(request()->query('per_page'))
            ->appends(request()->query());

        return ProjectCharterEscalationRequestTransformer::collection($query);
    }
}
