<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterEscalationRequestResource;
use App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Transformers\ProjectCharterEscalationRequestTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterEscalationRequestResource::class;

    /**
     * Show ProjectCharterEscalationRequest
     *
     * @return ProjectCharterEscalationRequestTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new ProjectCharterEscalationRequestTransformer($query);
    }
}
