<?php

namespace App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterEscalationRequestResource;
use App\Filament\Resources\ProjectCharterEscalationRequestResource\Api\Requests\CreateProjectCharterEscalationRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterEscalationRequestResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ProjectCharterEscalationRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateProjectCharterEscalationRequestRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
