<?php

namespace App\Filament\Resources\ProjectCharterDeliverableResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateProjectCharterDeliverableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'description' => 'required|string',
            'expected_delivery_date' => 'required|date',
            'weight' => 'required',
            'payment_number' => 'required',
            'project_charter_id' => 'required',
            'estimated_cost' => 'required',
            'created_by' => 'required',
            'file_status' => 'required',
            'approved_by' => 'required',
            'approved_at' => 'required',
            'rejection_reason' => 'required|string',
        ];
    }
}
