<?php

namespace App\Filament\Resources\ProjectCharterDeliverableResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterDeliverableResource;
use App\Filament\Resources\ProjectCharterDeliverableResource\Api\Requests\UpdateProjectCharterDeliverableRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterDeliverableResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ProjectCharterDeliverable
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateProjectCharterDeliverableRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
