<?php

namespace App\Filament\Resources\ProjectCharterDeliverableResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterDeliverableResource;
use App\Filament\Resources\ProjectCharterDeliverableResource\Api\Requests\CreateProjectCharterDeliverableRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterDeliverableResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ProjectCharterDeliverable
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateProjectCharterDeliverableRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
