<?php

namespace App\Filament\Resources\ProjectCharterCompletionRequestResource\Pages;

use App\Filament\Resources\ProjectCharterCompletionRequestResource;
use Filament\Actions;
use Filament\Forms;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\ViewRecord;
use Illuminate\Support\Facades\Auth;

class ViewProjectCharterCompletionRequest extends ViewRecord
{
    protected static string $resource = ProjectCharterCompletionRequestResource::class;

    protected function getHeaderActions(): array
    {
        $record = $this->getRecord();
        $actions = [];

        // Approve action
        if ($record->canApprove() && Auth::user()->can('approve_completion_request_project::charter::completion::request')) {
            $actions[] = Actions\Action::make('approve')
                ->label(__('project_charter_completion_request.approve_request'))
                ->icon('heroicon-o-check-circle')
                ->color('success')
                ->requiresConfirmation()
                ->modalHeading(__('project_charter_completion_request.approve_request_confirmation'))
                ->modalDescription(__('project_charter_completion_request.approve_request_description'))
                ->form([
                    Forms\Components\Textarea::make('review_notes')
                        ->label(__('project_charter_completion_request.review_notes'))
                        ->rows(3)
                        ->placeholder(__('project_charter_completion_request.approval_notes_placeholder')),
                ])
                ->action(function (array $data) use ($record) {
                    if ($record->approve($data['review_notes'] ?? '')) {
                        Notification::make()
                            ->title(__('project_charter_completion_request.request_approved_successfully'))
                            ->success()
                            ->send();

                        return redirect(ProjectCharterCompletionRequestResource::getUrl('index'));
                    } else {
                        Notification::make()
                            ->title(__('project_charter_completion_request.approval_failed'))
                            ->danger()
                            ->send();
                    }
                });
        }

        // Reject action
        if ($record->canReject() && Auth::user()->can('reject_completion_request_project::charter::completion::request')) {
            $actions[] = Actions\Action::make('reject')
                ->label(__('project_charter_completion_request.reject_request'))
                ->icon('heroicon-o-x-circle')
                ->color('danger')
                ->requiresConfirmation()
                ->modalHeading(__('project_charter_completion_request.reject_request_confirmation'))
                ->modalDescription(__('project_charter_completion_request.reject_request_description'))
                ->form([
                    Forms\Components\Textarea::make('review_notes')
                        ->label(__('project_charter_completion_request.review_notes'))
                        ->required()
                        ->rows(3)
                        ->placeholder(__('project_charter_completion_request.rejection_notes_placeholder')),
                ])
                ->action(function (array $data) use ($record) {
                    if ($record->reject($data['review_notes'])) {
                        Notification::make()
                            ->title(__('project_charter_completion_request.request_rejected_successfully'))
                            ->success()
                            ->send();

                        return redirect(ProjectCharterCompletionRequestResource::getUrl('index'));
                    } else {
                        Notification::make()
                            ->title(__('project_charter_completion_request.rejection_failed'))
                            ->danger()
                            ->send();
                    }
                });
        }

        // Edit action (only for pending requests by the requester)
        if (
            $record->status === \App\Models\ProjectCharterCompletionRequest::STATUS_PENDING &&
            Auth::id() === $record->requested_by
        ) {
            $actions[] = Actions\EditAction::make();
        }

        return $actions;
    }
}
