<?php

namespace App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectCharterCompletionRequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'project_charter_id' => 'required',
            'type' => 'required',
            'status' => 'required',
            'reason' => 'required|string',
            'requested_by' => 'required',
            'reviewed_by' => 'required',
            'review_notes' => 'required|string',
            'reviewed_at' => 'required',
            'actual_end_date' => 'required|date',
            'learned_lessons' => 'required|string',
            'notes' => 'required|string',
        ];
    }
}
