<?php

namespace App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterCompletionRequestResource;
use App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Requests\UpdateProjectCharterCompletionRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterCompletionRequestResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ProjectCharterCompletionRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateProjectCharterCompletionRequestRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
