<?php

namespace App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterCompletionRequestResource;
use App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Transformers\ProjectCharterCompletionRequestTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class PaginationHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterCompletionRequestResource::class;

    /**
     * List of ProjectCharterCompletionRequest
     *
     * @param  Request  $request
     * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
     */
    public function handler()
    {
        $query = static::getEloquentQuery();

        $query = QueryBuilder::for($query)
            ->allowedFields($this->getAllowedFields() ?? [])
            ->allowedSorts($this->getAllowedSorts() ?? [])
            ->allowedFilters($this->getAllowedFilters() ?? [])
            ->allowedIncludes($this->getAllowedIncludes() ?? [])
            ->paginate(request()->query('per_page'))
            ->appends(request()->query());

        return ProjectCharterCompletionRequestTransformer::collection($query);
    }
}
