<?php

namespace App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterCompletionRequestResource;
use App\Filament\Resources\ProjectCharterCompletionRequestResource\Api\Requests\CreateProjectCharterCompletionRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterCompletionRequestResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ProjectCharterCompletionRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateProjectCharterCompletionRequestRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
