<?php

namespace App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectCharterChangeRequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'project_charter_id' => 'required',
            'change_type' => 'required',
            'status' => 'required',
            'justification' => 'required|string',
            'new_start_date' => 'required|date',
            'new_end_date' => 'required|date',
            'additional_duration_days' => 'required',
            'additional_cost' => 'required',
            'cost_breakdown' => 'required|string',
            'scope_changes' => 'required|string',
            'includes_duration_change' => 'required',
            'includes_cost_change' => 'required',
            'requested_by' => 'required',
            'reviewed_by' => 'required',
            'review_notes' => 'required|string',
            'reviewed_at' => 'required',
            'first_approved_by' => 'required',
            'first_approval_notes' => 'required|string',
            'first_approved_at' => 'required',
            'final_approved_by' => 'required',
            'final_approval_notes' => 'required|string',
            'final_approved_at' => 'required',
        ];
    }
}
