<?php

namespace App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterChangeRequestResource;
use App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Requests\UpdateProjectCharterChangeRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterChangeRequestResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ProjectCharterChangeRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateProjectCharterChangeRequestRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
