<?php

namespace App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterChangeRequestResource;
use App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Transformers\ProjectCharterChangeRequestTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ProjectCharterChangeRequestResource::class;

    /**
     * Show ProjectCharterChangeRequest
     *
     * @return ProjectCharterChangeRequestTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new ProjectCharterChangeRequestTransformer($query);
    }
}
