<?php

namespace App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Handlers;

use App\Filament\Resources\ProjectCharterChangeRequestResource;
use App\Filament\Resources\ProjectCharterChangeRequestResource\Api\Requests\CreateProjectCharterChangeRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ProjectCharterChangeRequestResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ProjectCharterChangeRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateProjectCharterChangeRequestRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
