<?php

namespace App\Filament\Resources\PerformanceCardResource\Api\Handlers;

use App\Filament\Resources\PerformanceCardResource;
use App\Filament\Resources\PerformanceCardResource\Api\Requests\UpdatePerformanceCardRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = PerformanceCardResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update PerformanceCard
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdatePerformanceCardRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
