<?php

namespace App\Filament\Resources\PerformanceCardResource\Api\Handlers;

use App\Filament\Resources\PerformanceCardResource;
use App\Filament\Resources\PerformanceCardResource\Api\Transformers\PerformanceCardTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = PerformanceCardResource::class;

    /**
     * Show PerformanceCard
     *
     * @return PerformanceCardTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new PerformanceCardTransformer($query);
    }
}
