<?php

namespace App\Filament\Resources\PerformanceCardResource\Api\Handlers;

use App\Filament\Resources\PerformanceCardResource;
use App\Filament\Resources\PerformanceCardResource\Api\Requests\CreatePerformanceCardRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = PerformanceCardResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create PerformanceCard
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreatePerformanceCardRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
