<?php

namespace App\Filament\Resources\OrderResource\Widgets;

use App\Models\Order;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        return [
            Stat::make(__('order.stats.total_orders'), Order::count())
                ->description(__('order.stats.total_orders_description')),
            Stat::make(__('order.stats.pending_orders'), Order::whereIn('status', [
                Order::STATUS_CREATED,
                Order::STATUS_PENDING_RECOMMENDATION,
                Order::STATUS_RECOMMENDED,
                Order::STATUS_TECHNICAL_FINANCIAL_REQUESTED,
                Order::STATUS_TECHNICAL_FINANCIAL_APPROVED,
                Order::STATUS_PROJECT_MANAGER_APPROVED,
                Order::STATUS_CLASSIFICATION,
                Order::STATUS_AGREEMENT,
                Order::STATUS_CEO_APPROVED,
            ])->count())
                ->description(__('order.stats.pending_orders_description')),
            Stat::make(__('order.stats.accepted_orders'), Order::where('status', Order::STATUS_ACCEPTED)->count())
                ->description(__('order.stats.accepted_orders_description')),
        ];
    }
}
