<?php

namespace App\Filament\Resources\OrderResource\Pages;

use App\Filament\Resources\OrderResource;
use Filament\Actions\Action;
use Filament\Forms;
use Filament\Forms\Get;
use Filament\Resources\Pages\CreateRecord;

class CreateOrder extends CreateRecord
{
    use CreateRecord\Concerns\HasWizard;

    protected static string $resource = OrderResource::class;

    public function getTitle(): string
    {
        return __('order.create_order');
    }

    protected function getCreateFormAction(): Action
    {
        return Action::make('create')
            ->label(__('order.create_order'))
            ->submit('create')
            ->keyBindings(['mod+s']);
    }

    protected function getSteps(): array
    {
        return [
            Forms\Components\Wizard\Step::make(__('order.order_information'))
                ->schema([
                    ...OrderResource::getOrderInformationFields(),
                    ...OrderResource::getLocationInformationFields(),
                    ...OrderResource::getWaterSourceInformationFields(),
                ])
                ->columns(2),

            Forms\Components\Wizard\Step::make(__('order.project_details'))
                ->schema(OrderResource::getProjectDetailsFields())
                ->columns(1),

            Forms\Components\Wizard\Step::make(__('order.required_files'))
                ->schema(function (Get $get) {
                    return OrderResource::getRequiredFilesFields($get);
                }),
        ];
    }
}
