<?php

namespace App\Filament\Resources\OrderResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'association_id' => 'required',
            'type' => 'required',
            'status' => 'required',
            'lat' => 'required',
            'lng' => 'required',
            'number_of_families' => 'required',
            'water_source' => 'required',
            'water_distance' => 'required',
            'order_justifications' => 'required|string',
            'order_description' => 'required|string',
            'created_by' => 'required',
            'state_id' => 'required',
            'city_id' => 'required',
        ];
    }
}
