<?php

namespace App\Filament\Resources\OrderResource\Api\Handlers;

use App\Filament\Resources\OrderResource;
use App\Filament\Resources\OrderResource\Api\Requests\UpdateOrderRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = OrderResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update Order
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateOrderRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
