<?php

namespace App\Filament\Resources\OrderResource\Api\Handlers;

use App\Filament\Resources\OrderResource;
use App\Filament\Resources\OrderResource\Api\Transformers\OrderTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = OrderResource::class;

    /**
     * Show Order
     *
     * @return OrderTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new OrderTransformer($query);
    }
}
