<?php

namespace App\Filament\Resources\OrderResource\Api\Handlers;

use App\Filament\Resources\OrderResource;
use App\Filament\Resources\OrderResource\Api\Requests\CreateOrderRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = OrderResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create Order
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateOrderRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
