<?php

namespace App\Filament\Resources\InitiativeResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class ResultsRelationManager extends RelationManager
{
    protected static string $relationship = 'results';

    protected static ?string $title = 'Initiative Results';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('initiative_result.initiative_results');
    }

    public static function getModelLabel(): string
    {
        return __('initiative_result.initiative_result');
    }

    public static function getPluralModelLabel(): string
    {
        return __('initiative_result.initiative_results');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([

                Forms\Components\Section::make(__('initiative_result.quarterly_targets'))
                    ->schema([
                        Forms\Components\Grid::make(2)
                            ->schema([
                                Forms\Components\TextInput::make('expected_q1')
                                    ->label(__('initiative_result.expected_q1'))
                                    ->numeric()
                                    ->step(0.01),
                                Forms\Components\TextInput::make('actual_q1')
                                    ->label(__('initiative_result.actual_q1'))
                                    ->numeric()
                                    ->step(0.01),
                            ]),
                        Forms\Components\Grid::make(2)
                            ->schema([
                                Forms\Components\TextInput::make('expected_q2')
                                    ->label(__('initiative_result.expected_q2'))
                                    ->numeric()
                                    ->step(0.01),
                                Forms\Components\TextInput::make('actual_q2')
                                    ->label(__('initiative_result.actual_q2'))
                                    ->numeric()
                                    ->step(0.01),
                            ]),
                        Forms\Components\Grid::make(2)
                            ->schema([
                                Forms\Components\TextInput::make('expected_q3')
                                    ->label(__('initiative_result.expected_q3'))
                                    ->numeric()
                                    ->step(0.01),
                                Forms\Components\TextInput::make('actual_q3')
                                    ->label(__('initiative_result.actual_q3'))
                                    ->numeric()
                                    ->step(0.01),
                            ]),
                        Forms\Components\Grid::make(2)
                            ->schema([
                                Forms\Components\TextInput::make('expected_q4')
                                    ->label(__('initiative_result.expected_q4'))
                                    ->numeric()
                                    ->step(0.01),
                                Forms\Components\TextInput::make('actual_q4')
                                    ->label(__('initiative_result.actual_q4'))
                                    ->numeric()
                                    ->step(0.01),
                            ]),
                    ]),

                Forms\Components\Select::make('performanceCardResults')
                    ->label(__('initiative_result.performance_card_results'))
                    ->multiple()
                    ->relationship(
                        'performanceCardResults',
                        'result',
                        function (Builder $query) {
                            // Filter to show only performance card results that belong to this initiative's wallet's performance card
                            $initiative = $this->getOwnerRecord();
                            if ($initiative && $initiative->performanceWallet && $initiative->performanceWallet->performance_card_id) {
                                $query->where('performance_card_id', $initiative->performanceWallet->performance_card_id);
                            } else {
                                // If no performance wallet is assigned, show no results
                                $query->whereRaw('1 = 0');
                            }
                        }
                    )
                    ->preload()
                    ->searchable()
                    ->getOptionLabelFromRecordUsing(function ($record) {
                        return $record->performanceCard->goal.' - '.$record->result;
                    })
                    ->helperText(function () {
                        $initiative = $this->getOwnerRecord();
                        if (! $initiative || ! $initiative->performanceWallet) {
                            return __('initiative_result.no_wallet_assigned');
                        }

                        return __('initiative_result.performance_card_results_helper');
                    })
                    ->disabled(function () {
                        $initiative = $this->getOwnerRecord();

                        return ! $initiative || ! $initiative->performanceWallet;
                    }),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([

                Tables\Columns\TextColumn::make('expected_q1')
                    ->label(__('initiative_result.expected_q1'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('actual_q1')
                    ->label(__('initiative_result.actual_q1'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('expected_q2')
                    ->label(__('initiative_result.expected_q2'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('actual_q2')
                    ->label(__('initiative_result.actual_q2'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('expected_q3')
                    ->label(__('initiative_result.expected_q3'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('actual_q3')
                    ->label(__('initiative_result.actual_q3'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('expected_q4')
                    ->label(__('initiative_result.expected_q4'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('actual_q4')
                    ->label(__('initiative_result.actual_q4'))
                    ->numeric(decimalPlaces: 2)
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('performance_card_results_count')
                    ->label(__('initiative_result.linked_results_count'))
                    ->counts('performanceCardResults')
                    ->sortable(),
            ])
            ->filters([])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public function isReadOnly(): bool
    {
        return false;
    }
}
