<?php

namespace App\Filament\Resources\InitiativeResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class OperationGoalsRelationManager extends RelationManager
{
    protected static string $relationship = 'operationGoals';

    protected static ?string $title = 'Operation Goals';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('initiative_operation_goal.operation_goals');
    }

    public static function getModelLabel(): string
    {
        return __('initiative_operation_goal.operation_goal');
    }

    public static function getPluralModelLabel(): string
    {
        return __('initiative_operation_goal.operation_goals');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('initiative_operation_goal.name'))
                    ->required()
                    ->maxLength(255)
                    ->helperText(__('initiative_operation_goal.name_helper')),

                Forms\Components\TextInput::make('performance_criteria')
                    ->label(__('initiative_operation_goal.performance_criteria'))
                    ->required()
                    ->maxLength(1000)
                    ->helperText(__('initiative_operation_goal.performance_criteria_helper')),

                Forms\Components\TextInput::make('target')
                    ->label(__('initiative_operation_goal.target'))
                    ->required()
                    ->maxLength(500)
                    ->helperText(__('initiative_operation_goal.target_helper')),

                Forms\Components\TextInput::make('actual')
                    ->label(__('initiative_operation_goal.actual'))
                    ->maxLength(500)
                    ->helperText(__('initiative_operation_goal.actual_helper')),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('initiative_operation_goal.name'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('performance_criteria')
                    ->label(__('initiative_operation_goal.performance_criteria'))
                    ->limit(20)
                    ->searchable(),

                Tables\Columns\TextColumn::make('target')
                    ->label(__('initiative_operation_goal.target'))
                    ->limit(30)
                    ->searchable(),

                Tables\Columns\TextColumn::make('actual')
                    ->label(__('initiative_operation_goal.actual'))
                    ->limit(30)
                    ->placeholder(__('initiative_operation_goal.not_measured_yet'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('initiative_operation_goal.created_at'))
                    ->date()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public function isReadOnly(): bool
    {
        return false;
    }
}
