<?php

namespace App\Filament\Resources\InitiativeResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateInitiativeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'start_date' => 'required|date',
            'expected_end_date' => 'required|date',
            'description' => 'required|string',
            'expected_cost' => 'required',
            'emergency_reserve' => 'required',
            'performance_wallet_id' => 'required',
            'created_by' => 'required',
        ];
    }
}
