<?php

namespace App\Filament\Resources\InitiativeResource\Api\Handlers;

use App\Filament\Resources\InitiativeResource;
use App\Filament\Resources\InitiativeResource\Api\Requests\UpdateInitiativeRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = InitiativeResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update Initiative
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateInitiativeRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
