<?php

namespace App\Filament\Resources\InitiativeResource\Api\Handlers;

use App\Filament\Resources\InitiativeResource;
use App\Filament\Resources\InitiativeResource\Api\Transformers\InitiativeTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = InitiativeResource::class;

    /**
     * Show Initiative
     *
     * @return InitiativeTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new InitiativeTransformer($query);
    }
}
