<?php

namespace App\Filament\Resources\InitiativeResource\Api\Handlers;

use App\Filament\Resources\InitiativeResource;
use App\Filament\Resources\InitiativeResource\Api\Requests\CreateInitiativeRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = InitiativeResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create Initiative
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateInitiativeRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
