<?php

namespace App\Filament\Resources\ExchangeRequestResource\Api\Handlers;

use App\Filament\Resources\ExchangeRequestResource;
use App\Filament\Resources\ExchangeRequestResource\Api\Requests\UpdateExchangeRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ExchangeRequestResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ExchangeRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateExchangeRequestRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
