<?php

namespace App\Filament\Resources\ExchangeRequestResource\Api\Handlers;

use App\Filament\Resources\ExchangeRequestResource;
use App\Filament\Resources\ExchangeRequestResource\Api\Transformers\ExchangeRequestTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ExchangeRequestResource::class;

    /**
     * Show ExchangeRequest
     *
     * @return ExchangeRequestTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new ExchangeRequestTransformer($query);
    }
}
