<?php

namespace App\Filament\Resources\ExchangeRequestResource\Api\Handlers;

use App\Filament\Resources\ExchangeRequestResource;
use App\Filament\Resources\ExchangeRequestResource\Api\Requests\CreateExchangeRequestRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ExchangeRequestResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ExchangeRequest
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateExchangeRequestRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
