<?php

namespace App\Filament\Resources\DonorFinancialPortfolioResource\Pages;

use App\Filament\Resources\DonorFinancialPortfolioResource;
use App\Filament\Resources\OrderResource;
use App\Models\Order;
use Filament\Actions;
use Filament\Infolists\Components\Grid;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Filament\Support\Enums\FontWeight;
use Illuminate\Support\HtmlString;

class ViewDonorFinancialPortfolio extends ViewRecord
{
    protected static string $resource = DonorFinancialPortfolioResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                // Portfolio Information Card
                Section::make(__('donor_financial_portfolio.portfolio_information'))
                    ->icon('heroicon-o-banknotes')
                    ->schema([
                        Grid::make(3)
                            ->schema([
                                TextEntry::make('name')
                                    ->label(__('donor_financial_portfolio.name'))
                                    ->weight(FontWeight::Bold)
                                    ->size('lg')
                                    ->icon('heroicon-o-identification'),

                                TextEntry::make('balance')
                                    ->label(__('donor_financial_portfolio.balance'))
                                    ->numeric(2)
                                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                    ->weight(FontWeight::SemiBold)
                                    ->color('primary'),

                                TextEntry::make('operating_percentage')
                                    ->label(__('donor_financial_portfolio.operating_percentage'))
                                    ->numeric(2)
                                    ->suffix('%')
                                    ->weight(FontWeight::SemiBold)
                                    ->color('warning'),
                            ]),

                        Grid::make(3)
                            ->schema([
                                TextEntry::make('total_operating_value')
                                    ->label(__('donor_financial_portfolio.total_operating_value'))
                                    ->numeric(2)
                                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                    ->color('info')
                                    ->helperText(__('donor_financial_portfolio.operating_percentage').' × '.__('donor_financial_portfolio.balance')),

                                TextEntry::make('total_allocated')
                                    ->label(__('donor_financial_portfolio.total_allocated'))
                                    ->numeric(2)
                                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                    ->color('success'),

                                TextEntry::make('remaining_balance')
                                    ->label(__('donor_financial_portfolio.remaining_balance'))
                                    ->numeric(2)
                                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                                    ->weight(FontWeight::Bold)
                                    ->size('lg')
                                    ->color(fn ($state) => $state < 0 ? 'danger' : ($state == 0 ? 'warning' : 'success'))
                                    ->icon(fn ($state) => $state < 0 ? 'heroicon-o-exclamation-triangle' : 'heroicon-o-check-circle'),
                            ]),

                        Grid::make(3)
                            ->schema([
                                // TextEntry::make('tags.name')
                                //     ->label(__('donor_financial_portfolio.tags'))
                                //     ->badge()
                                //     ->columnSpanFull()
                                //     ->placeholder(__('donor_financial_portfolio.no_tags')),

                                TextEntry::make('creator.name')
                                    ->label(__('common.created_by'))
                                    ->icon('heroicon-o-user'),

                                TextEntry::make('created_at')
                                    ->label(__('donor_financial_portfolio.created_at'))
                                    ->date()
                                    ->icon('heroicon-o-calendar'),

                                TextEntry::make('updated_at')
                                    ->label(__('donor_financial_portfolio.updated_at'))
                                    ->date()
                                    ->icon('heroicon-o-clock'),
                            ]),
                    ]),

                // Related Orders Card
                Section::make(__('donor_financial_portfolio.related_orders'))
                    ->icon('heroicon-o-document-text')
                    ->description(__('donor_financial_portfolio.related_orders_description'))
                    ->schema([
                        TextEntry::make('orders')
                            ->label(false)
                            ->listWithLineBreaks()
                            ->bulleted()
                            ->formatStateUsing(function (Order $state) {
                                // return 'id - association name - order type', when clicked goes to order view page
                                $url = OrderResource::getUrl('view', ['record' => $state->id]);

                                return new HtmlString('<a href="'.$url.'" class="text-primary-600 hover:underline">'.$state->id.' - '.$state->association->name.' - '.$state->getAllOrderTypes()[$state->type].'</a>');
                            })
                            ->placeholder(__('donor_financial_portfolio.no_orders'))
                            ->columnSpanFull(),
                    ])
                    ->visible(fn ($record) => $record->orders->count() > 0),
            ]);
    }
}
