<?php

namespace App\Filament\Resources\DonorFinancialPortfolioResource\Api\Handlers;

use App\Filament\Resources\DonorFinancialPortfolioResource;
use App\Filament\Resources\DonorFinancialPortfolioResource\Api\Requests\UpdateDonorFinancialPortfolioRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = DonorFinancialPortfolioResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update DonorFinancialPortfolio
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateDonorFinancialPortfolioRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
