<?php

namespace App\Filament\Resources\DonorFinancialPortfolioResource\Api\Handlers;

use App\Filament\Resources\DonorFinancialPortfolioResource;
use App\Filament\Resources\DonorFinancialPortfolioResource\Api\Transformers\DonorFinancialPortfolioTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = DonorFinancialPortfolioResource::class;

    /**
     * Show DonorFinancialPortfolio
     *
     * @return DonorFinancialPortfolioTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new DonorFinancialPortfolioTransformer($query);
    }
}
