<?php

namespace App\Filament\Resources\DonorFinancialPortfolioResource\Api\Handlers;

use App\Filament\Resources\DonorFinancialPortfolioResource;
use App\Filament\Resources\DonorFinancialPortfolioResource\Api\Requests\CreateDonorFinancialPortfolioRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = DonorFinancialPortfolioResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create DonorFinancialPortfolio
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateDonorFinancialPortfolioRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
