<?php

namespace App\Filament\Resources\DepartmentResource\Api\Handlers;

use App\Filament\Resources\DepartmentResource;
use App\Filament\Resources\DepartmentResource\Api\Transformers\DepartmentTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = DepartmentResource::class;

    /**
     * Show Department
     *
     * @return DepartmentTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new DepartmentTransformer($query);
    }
}
