<?php

namespace App\Filament\Resources\DepartmentResource\Api\Handlers;

use App\Filament\Resources\DepartmentResource;
use App\Filament\Resources\DepartmentResource\Api\Requests\CreateDepartmentRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = DepartmentResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create Department
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateDepartmentRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
