<?php

namespace App\Filament\Resources\AssociationResource\RelationManagers;

use App\Enums\LicenseStatus;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class WellLicensesRelationManager extends RelationManager
{
    protected static string $relationship = 'wellLicenses';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('well_license.well_licenses');
    }

    public static function getModelLabel(): string
    {
        return __('well_license.well_license');
    }

    public static function getPluralModelLabel(): string
    {
        return __('well_license.well_licenses');
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('well_name')
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID')
                    ->badge()
                    ->color('gray')
                    ->prefix('#')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('well_name')
                    ->label(__('well_license.well_name'))
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('status')
                    ->label(__('well_license.status'))
                    ->badge()
                    ->formatStateUsing(fn (LicenseStatus $state): string => $state->getLabel()),

                Tables\Columns\TextColumn::make('ministry_license_number')
                    ->label(__('well_license.ministry_license_number'))
                    ->badge()
                    ->color('success')
                    ->searchable()
                    ->placeholder('—')
                    ->toggleable(isToggledHiddenByDefault: false),

                Tables\Columns\TextColumn::make('state.name')
                    ->label(__('well_license.state'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('city.name')
                    ->label(__('well_license.city'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('well_license.created_at'))
                    ->date()
                    ->sortable(),
            ])
            ->filters([])
            ->actions([
                Tables\Actions\ViewAction::make()
                    ->url(fn ($record) => \App\Filament\Resources\WellLicenseResource::getUrl('view', ['record' => $record])),
            ])
            ->defaultSort('created_at', 'desc');
    }
}
