<?php

namespace App\Filament\Resources\AssociationResource\RelationManagers;

use App\Models\ProjectCharter;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Support\HtmlString;

class ProjectChartersRelationManager extends RelationManager
{
    protected static string $relationship = 'projectCharters';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('project_charter.project_charters');
    }

    public static function getModelLabel(): string
    {
        return __('project_charter.project_charter');
    }

    public static function getPluralModelLabel(): string
    {
        return __('project_charter.project_charters');
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('project_charter.name'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('start_date')
                    ->label(__('project_charter.start_date'))
                    ->date()
                    ->sortable(),

                Tables\Columns\TextColumn::make('expected_end_date')
                    ->label(__('project_charter.expected_end_date'))
                    ->date()
                    ->sortable(),

                Tables\Columns\TextColumn::make('estimated_cost')
                    ->label(__('project_charter.estimated_cost'))
                    ->numeric(2)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('total_cost')
                    ->label(__('project_charter.total_cost'))
                    ->numeric(2)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('description')
                    ->label(__('project_charter.description'))
                    ->sortable()
                    ->searchable()
                    ->limit(20),

                Tables\Columns\TextColumn::make('status')
                    ->label(__('project_charter.status'))
                    ->badge()
                    ->formatStateUsing(fn (string $state): string => __(ProjectCharter::getStatuses()[$state] ?? $state)),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([])
            ->actions([
                Tables\Actions\ViewAction::make()
                    ->url(fn ($record) => \App\Filament\Resources\ProjectCharterResource::getUrl('view', ['record' => $record])),
            ])
            ->defaultSort('created_at', 'desc');
    }
}
