<?php

namespace App\Filament\Resources\AssociationResource\RelationManagers;

use App\Models\Order;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class OrdersRelationManager extends RelationManager
{
    protected static string $relationship = 'orders';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('order.orders');
    }

    public static function getModelLabel(): string
    {
        return __('order.order');
    }

    public static function getPluralModelLabel(): string
    {
        return __('order.orders');
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label(__('common.id'))
                    ->badge()
                    ->prefix('#')
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('type')
                    ->label(__('order.order_type'))
                    ->badge()
                    ->formatStateUsing(fn ($state) => Order::getAllOrderTypes()[$state] ?? $state)
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('status')
                    ->label(__('order.status'))
                    ->badge()
                    ->formatStateUsing(fn ($state) => Order::getOrderStatuses()[$state] ?? $state)
                    ->sortable(),

                Tables\Columns\TextColumn::make('state.name')
                    ->label(__('order.state'))
                    ->sortable()
                    ->searchable()
                    ->toggleable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([])
            ->actions([
                Tables\Actions\ViewAction::make()
                    ->url(fn ($record) => \App\Filament\Resources\OrderResource::getUrl('view', ['record' => $record])),
            ])
            ->defaultSort('created_at', 'desc');
    }
}
